/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSMineshaftConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class MineshaftStructure<C extends RSMineshaftConfig>
extends AdvancedJigsawStructure<C> {
    public MineshaftStructure(Codec<C> codec) {
        super(codec, MineshaftStructure::isMineshaftFeatureChunk, MineshaftStructure::generateMineshaftPieces);
    }

    public MineshaftStructure(Codec<C> codec, Predicate<PieceGeneratorSupplier.Context<C>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<C>, Optional<PieceGenerator<C>>> pieceCreationPredicate) {
        super(codec, locationCheckPredicate, pieceCreationPredicate);
    }

    protected static <CC extends RSMineshaftConfig> boolean isMineshaftFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenRandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        double chance = ((RSMineshaftConfig)context.f_197356_()).probability;
        if (worldgenRandom.nextDouble() >= chance) {
            return false;
        }
        Holder biomeAtSpot = context.f_197352_().m_203495_(QuartPos.m_175400_((int)context.f_197355_().m_151390_()), QuartPos.m_175400_((int)50), QuartPos.m_175400_((int)context.f_197355_().m_151393_()));
        return context.f_197358_().test(biomeAtSpot) && AdvancedJigsawStructure.isAdvancedFeatureChunk(context);
    }

    public static <CC extends RSMineshaftConfig> Optional<PieceGenerator<CC>> generateMineshaftPieces(PieceGeneratorSupplier.Context<CC> context) {
        int bottomClipOff;
        int topClipOff;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(context.f_197355_().m_45604_(), 0, context.f_197355_().m_45605_());
        RSMineshaftConfig config = (RSMineshaftConfig)context.f_197356_();
        if (config.maxY - config.minY <= 0) {
            RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + ((ResourceKey)config.startPool.m_203543_().get()).m_135782_());
        }
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        int structureStartHeight = random.nextInt(config.maxY - config.minY) + config.minY;
        blockpos.m_122175_(Direction.UP, structureStartHeight);
        if (config.verticalRange.isEmpty()) {
            topClipOff = config.clipOutOfBoundsPieces ? config.maxY + 5 : Integer.MAX_VALUE;
            bottomClipOff = config.clipOutOfBoundsPieces ? config.minY - 5 : Integer.MIN_VALUE;
        } else {
            topClipOff = structureStartHeight + (Integer)config.verticalRange.get();
            bottomClipOff = structureStartHeight - (Integer)config.verticalRange.get();
        }
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.f_197360_()), (BlockPos)blockpos, false, false, topClipOff, bottomClipOff, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {
            int justBelowTerrain = MineshaftStructure.getTerrainHeight(context.f_197355_().m_151394_(0), context.f_197352_(), context.f_197357_()) - 15;
            int finalJustBelowTerrain = Math.max(justBelowTerrain, bottomClipOff);
            Optional<PoolElementStructurePiece> topPiece = pieces.stream().max(Comparator.comparingInt(piece -> piece.m_73547_().m_162400_()));
            if (topPiece.isPresent() && finalJustBelowTerrain < topClipOff && finalJustBelowTerrain < topPiece.get().m_73547_().m_162400_()) {
                int topPieceMaxY = topPiece.get().m_73547_().m_162400_();
                pieces.forEach(piece -> piece.m_6324_(0, finalJustBelowTerrain - topPieceMaxY, 0));
            }
        });
    }

    private static int getTerrainHeight(BlockPos centerPos, ChunkGenerator chunkGenerator, LevelHeightAccessor heightLimitView) {
        int height = chunkGenerator.m_156179_(centerPos.m_123341_(), centerPos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView);
        BlockPos pos = new BlockPos(centerPos.m_123341_(), GeneralUtils.getMaxTerrainLimit(chunkGenerator), centerPos.m_123343_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.m_122190_((Vec3i)pos).m_122175_(direction, 16);
            height = Math.min(height, chunkGenerator.m_156179_(mutable.m_123341_(), mutable.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView));
        }
        return height;
    }
}

